function makeCommunitiesCSV(obj,fileName,commLabels)
%MAKECOMMUNITIESCSV Output a CSV (comma-separated values) file, ordering
%rows and columns by community membership
%   makeCommunitiesCSV(adjMat,fileName,commLabels) will create a CSV file
%       with the name 'fileName' (extension included), and will order the
%       rows by community membership, which is specified in commLabels
%       (this is likely the output of the getCommunitiesMM function



labels = {};

% disp('Community structure');

for k = 1:numel(commLabels)
%     fprintf('\nCommunity %u\n',k);
    labels = [labels createList(commLabels(k),'')];

end

labels = labels';

[subMatrix newA] = getSubMatrix(obj,labels);

AdjacencyMatrix.writeToFile(fileName,newA,labels,labels');






end

